/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class QKeeperEditMain {
    private static final String ID_STRING = "QKeeperDocument";
    private static String CSV_SEPARATOR = "\t";
    private static String mPassword;
    private static String mFileName;

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args.length < 2 || args[0].equals("-h") || args[0].equals("-?") || args[0].equals("h") || args[0].equals("?") || args[0].equals("/h") || args[0].equals("/?")) {
            System.out.println("Version: V1.0");
            System.out.println("Usage: <Input Filename> <Password>");
        } else {
            int i = 0;
            while (i < args.length) {
                mFileName = args[0];
                mPassword = args[1];
                ++i;
            }
            QKeeperEditMain.loadCVSDocument();
        }
    }

    public static boolean loadCVSDocument() {
        boolean ret = true;
        System.out.println("Start processing...");
        try {
            File file = new File(mFileName);
            int numBytes = (int)file.length();
            FileInputStream fis = new FileInputStream(mFileName);
            byte[] byteArray = new byte[numBytes];
            fis.read(byteArray);
            QKeeperCrypt qCrypt = new QKeeperCrypt(mPassword);
            String crypto = new String(byteArray);
            String cleartext = qCrypt.decrypt(crypto);
            fis.close();
            String[] token = cleartext.split(CSV_SEPARATOR);
            if (token[0].equals(ID_STRING)) {
                String docVersionStr = token[1];
                int docVersionNum = Integer.valueOf(docVersionStr);
                int N = Integer.valueOf(token[3]);
                int M = Integer.valueOf(token[4 + 5 * N]);
                int catOffs = 4;
                int cat = 0;
                while (cat < N) {
                    int catId = Integer.valueOf(token[cat * 5 + 0 + catOffs]);
                    String catName = token[cat * 5 + 1 + catOffs];
                    int catResId = Integer.valueOf(token[cat * 5 + 2 + catOffs]);
                    String catResName = token[cat * 5 + 3 + catOffs];
                    int catResFlags = Integer.valueOf(token[cat * 5 + 4 + catOffs]);
                    if (docVersionNum < 6) {
                        if (catName.equalsIgnoreCase("internet")) {
                            catName = "Internet";
                        }
                        if (catName.equalsIgnoreCase("system")) {
                            catName = "Banking";
                        }
                        if (catName.equalsIgnoreCase("Tools")) {
                            catName = "Credit cards";
                        }
                        if (catName.equalsIgnoreCase("Science")) {
                            catName = "Access";
                        }
                        if (catName.equalsIgnoreCase("other")) {
                            catName = "Other";
                        }
                    }
                    System.out.print(String.valueOf(catId) + ", ");
                    System.out.print(String.valueOf(catName) + ", ");
                    System.out.print(String.valueOf(catResId) + ", ");
                    System.out.print(String.valueOf(catResName) + ", ");
                    System.out.println(catResFlags);
                    ++cat;
                }
                int pwOffs = 5 + 5 * N;
                int pw = 0;
                while (pw < M) {
                    String strURL;
                    String strHint;
                    String strRem;
                    String strPW;
                    String strUN;
                    String strRef;
                    int catId;
                    if (docVersionNum < 4) {
                        catId = Integer.valueOf(token[pw * 5 + 0 + pwOffs]);
                        strRef = token[pw * 5 + 1 + pwOffs];
                        strUN = token[pw * 5 + 2 + pwOffs];
                        strPW = token[pw * 5 + 3 + pwOffs];
                        strRem = token[pw * 5 + 4 + pwOffs];
                        strHint = "";
                        strURL = "";
                    } else {
                        catId = Integer.valueOf(token[pw * 11 + 0 + pwOffs]);
                        strRef = token[pw * 11 + 1 + pwOffs];
                        strUN = token[pw * 11 + 2 + pwOffs];
                        strPW = token[pw * 11 + 3 + pwOffs];
                        strRem = token[pw * 11 + 4 + pwOffs];
                        strHint = token[pw * 11 + 5 + pwOffs];
                        strURL = token[pw * 11 + 6 + pwOffs];
                    }
                    System.out.print(String.valueOf(catId) + ", ");
                    System.out.print(String.valueOf(strRef) + ", ");
                    System.out.print(String.valueOf(strUN) + ", ");
                    System.out.print(String.valueOf(strPW) + ", ");
                    System.out.print(String.valueOf(strRem) + ", ");
                    System.out.print(String.valueOf(strHint) + ", ");
                    System.out.println(strURL);
                    ++pw;
                }
                int extraOffs = docVersionNum < 4 ? M * 5 + pwOffs : M * 11 + pwOffs;
                if (docVersionNum > 1) {
                    String string = token[extraOffs];
                }
                ret = true;
            } else {
                ret = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
            ret = false;
        }
        return ret;
    }
}

