/*
 * Decompiled with CFR 0.152.
 */
package com.cloudgarden.layout;

import com.cloudgarden.layout.AnchorConstraint;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;

public class AnchorLayout
implements LayoutManager2 {
    private int preferredWidth;
    private int preferredHeight;
    private int minHeight;
    private int minWidth;
    private HashMap constraintMap = new HashMap();
    private boolean sizesCalculated = false;
    private Container container;

    void initialize(Container parent) {
        if (this.sizesCalculated) {
            return;
        }
        Component[] children = parent.getComponents();
        this.preferredWidth = 10000;
        this.preferredHeight = 10000;
        this.minWidth = 0;
        this.minHeight = 0;
        Rectangle pb = parent.getBounds();
        int i = 0;
        while (i < children.length) {
            Component child = children[i];
            if (child != null) {
                Object ld = this.constraintMap.get(child);
                Rectangle b = child.getBounds();
                Dimension pref = child.getPreferredSize();
                Dimension min = child.getMaximumSize();
                if (pref == null) {
                    pref = child.getSize();
                }
                if (min == null) {
                    min = child.getSize();
                }
                int minX = b.x + b.width;
                int minY = b.y + b.height;
                int maxX = b.x + b.width;
                int maxY = b.y + b.height;
                if (ld instanceof AnchorConstraint) {
                    AnchorConstraint ac = (AnchorConstraint)ld;
                    int acl = ac.left;
                    int acr = ac.right;
                    int aclt = ac.leftType;
                    int acrt = ac.rightType;
                    if (aclt == 1) {
                        acl = acl * pb.width / 1000;
                    }
                    if (acrt == 1) {
                        acr = pb.width - acr * pb.width / 1000;
                    }
                    if (aclt != 0 && acrt != 0) {
                        maxX = acl + pref.width + acr;
                    }
                    if (aclt == 0) {
                        acl = 0;
                    }
                    if (acrt == 0) {
                        acr = 0;
                    }
                    minX = acl + min.width + acr;
                    int act = ac.top;
                    int acb = ac.bottom;
                    int actt = ac.topType;
                    int acbt = ac.bottomType;
                    if (actt == 1) {
                        act = act * pb.height / 1000;
                    }
                    if (acbt == 1) {
                        acb = pb.height - acb * pb.height / 1000;
                    }
                    if (actt != 0 && acbt != 0) {
                        maxY = act + pref.height + acb;
                    }
                    if (actt == 0) {
                        act = 0;
                    }
                    if (acbt == 0) {
                        acb = 0;
                    }
                    minY = act + min.height + acb;
                }
                if (minX > this.minWidth) {
                    this.minWidth = minX;
                }
                if (maxX > this.minWidth) {
                    this.preferredWidth = maxX;
                }
                if (minY > this.minHeight) {
                    this.minHeight = minY;
                }
                if (maxY > this.preferredHeight) {
                    this.preferredHeight = maxY;
                }
            }
            ++i;
        }
    }

    @Override
    public void layoutContainer(Container container) {
        this.container = container;
        Component[] children = container.getComponents();
        Rectangle rect = container.getBounds();
        int width = rect.width;
        int height = rect.height;
        int i = 0;
        while (i < children.length) {
            Component child = children[i];
            if (child != null) {
                Object ld = this.constraintMap.get(child);
                Rectangle b = child.getBounds();
                Dimension pref = child.getPreferredSize();
                if (pref == null) {
                    pref = child.getSize();
                }
                if (ld instanceof AnchorConstraint) {
                    AnchorConstraint ac = (AnchorConstraint)ld;
                    int acl = ac.left;
                    int acr = ac.right;
                    int aclt = ac.leftType;
                    int acrt = ac.rightType;
                    if (aclt == 1) {
                        acl = acl * width / 1000;
                    }
                    if (acrt == 1) {
                        acr = width - acr * width / 1000;
                    }
                    if (aclt != 0) {
                        if (acrt != 0) {
                            b.width = width - acr - acl;
                            b.x = acl;
                        } else {
                            b.width = pref.width;
                            if (b.width + acl > width) {
                                b.width = width - acl;
                            }
                            b.x = acl;
                        }
                    } else {
                        if (acrt != 0) {
                            b.x = width - acr - pref.width;
                        }
                        b.width = pref.width;
                        if (b.width + b.x > width) {
                            b.width = width - b.x;
                        }
                    }
                    int act = ac.top;
                    int acb = ac.bottom;
                    int actt = ac.topType;
                    int acbt = ac.bottomType;
                    if (actt == 1) {
                        act = act * height / 1000;
                    }
                    if (acbt == 1) {
                        acb = height - acb * height / 1000;
                    }
                    if (actt != 0) {
                        if (acbt != 0) {
                            b.height = height - acb - act;
                            b.y = act;
                        } else {
                            b.height = pref.height;
                            if (b.height + act > height) {
                                b.height = height - act;
                            }
                            b.y = act;
                        }
                    } else {
                        if (acbt != 0) {
                            b.y = height - acb - pref.height;
                        }
                        b.height = pref.height;
                        if (b.height + b.y > height) {
                            b.height = height - b.y;
                        }
                    }
                    child.setBounds(b);
                }
            }
            ++i;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraintMap.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.initialize(parent);
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.initialize(parent);
        return new Dimension(this.minWidth, this.minHeight);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.constraintMap.put(comp, constraints);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.sizesCalculated = false;
    }
}

