/*
 * Decompiled with CFR 0.152.
 */
package de.qbert.doc;

import de.qbert.doc.Password;
import de.qbert.doc.QKeeperCrypt;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Document
extends AbstractTableModel {
    private static final String ID_STRING = "QKeeperDocument";
    private static String CSV_SEPARATOR = "\t";
    private static String mPassword;
    private static String mFileName;
    ArrayList<Password> mPW = new ArrayList();
    ArrayList<Password> mPWFiltered = new ArrayList();
    HashMap<Integer, String> mCategoryMap = new HashMap();

    public boolean load(String path, String password) {
        boolean ret = true;
        this.mPW.clear();
        this.mCategoryMap.clear();
        mFileName = path;
        mPassword = password;
        Security.addProvider((Provider)new BouncyCastleProvider());
        System.out.println("Start processing...");
        try {
            File file = new File(mFileName);
            int numBytes = (int)file.length();
            FileInputStream fis = new FileInputStream(mFileName);
            byte[] byteArray = new byte[numBytes];
            fis.read(byteArray);
            QKeeperCrypt qCrypt = new QKeeperCrypt(mPassword);
            String crypto = new String(byteArray);
            String cleartext = qCrypt.decrypt(crypto);
            fis.close();
            String[] token = cleartext.split(CSV_SEPARATOR);
            if (token[0].equals(ID_STRING)) {
                String docVersionStr = token[1];
                int docVersionNum = Integer.valueOf(docVersionStr);
                int N = Integer.valueOf(token[3]);
                int M = Integer.valueOf(token[4 + 5 * N]);
                int catOffs = 4;
                int cat = 0;
                while (cat < N) {
                    int catId = Integer.valueOf(token[cat * 5 + 0 + catOffs]);
                    String catName = token[cat * 5 + 1 + catOffs];
                    int catResId = Integer.valueOf(token[cat * 5 + 2 + catOffs]);
                    String catResName = token[cat * 5 + 3 + catOffs];
                    int catResFlags = Integer.valueOf(token[cat * 5 + 4 + catOffs]);
                    if (docVersionNum < 6) {
                        if (catName.equalsIgnoreCase("internet")) {
                            catName = "Internet";
                        }
                        if (catName.equalsIgnoreCase("system")) {
                            catName = "Banking";
                        }
                        if (catName.equalsIgnoreCase("Tools")) {
                            catName = "Credit cards";
                        }
                        if (catName.equalsIgnoreCase("Science")) {
                            catName = "Access";
                        }
                        if (catName.equalsIgnoreCase("other")) {
                            catName = "Other";
                        }
                    }
                    this.mCategoryMap.put(catId, catName);
                    ++cat;
                }
                int pwOffs = 5 + 5 * N;
                int pw = 0;
                while (pw < M) {
                    String strURL;
                    String strHint;
                    String strRem;
                    String strPW;
                    String strUN;
                    String strRef;
                    int catId;
                    if (docVersionNum < 4) {
                        catId = Integer.valueOf(token[pw * 5 + 0 + pwOffs]);
                        strRef = token[pw * 5 + 1 + pwOffs];
                        strUN = token[pw * 5 + 2 + pwOffs];
                        strPW = token[pw * 5 + 3 + pwOffs];
                        strRem = token[pw * 5 + 4 + pwOffs];
                        strHint = "";
                        strURL = "";
                    } else {
                        catId = Integer.valueOf(token[pw * 11 + 0 + pwOffs]);
                        strRef = token[pw * 11 + 1 + pwOffs];
                        strUN = token[pw * 11 + 2 + pwOffs];
                        strPW = token[pw * 11 + 3 + pwOffs];
                        strRem = token[pw * 11 + 4 + pwOffs];
                        strHint = token[pw * 11 + 5 + pwOffs];
                        strURL = token[pw * 11 + 6 + pwOffs];
                        Password myPW = new Password();
                        myPW.setmCategory(catId);
                        myPW.setmReference(strRef);
                        myPW.setmUserName(strUN);
                        myPW.setmPassword(strPW);
                        myPW.setmRemark(strRem);
                        myPW.setmHint(strHint);
                        myPW.setmURL(strURL);
                        this.mPW.add(myPW);
                    }
                    ++pw;
                }
                int extraOffs = docVersionNum < 4 ? M * 5 + pwOffs : M * 11 + pwOffs;
                if (docVersionNum > 1) {
                    String string = token[extraOffs];
                }
                ret = true;
            } else {
                ret = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
            ret = false;
        }
        this.setFilter("");
        return ret;
    }

    public void setFilter(String strFilter) {
        this.mPWFiltered.clear();
        if (strFilter.isEmpty()) {
            int y = 0;
            while (y < this.mPW.size()) {
                this.mPWFiltered.add(this.mPW.get(y));
                ++y;
            }
        } else {
            int col = this.getColumnCount();
            int y = 0;
            while (y < this.mPW.size()) {
                boolean rowFound = false;
                int x = 1;
                while (x < col && !rowFound) {
                    String filterLowerCase;
                    String str = (String)this.getValueAtOrig(y, x);
                    String strLowerCase = str.toLowerCase();
                    if (strLowerCase.contains(filterLowerCase = strFilter.toLowerCase())) {
                        rowFound = true;
                        this.mPWFiltered.add(this.mPW.get(y));
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    public int getColumnCount() {
        if (this.mPW != null) {
            Password pw = this.mPW.get(0);
            return pw.getEntries();
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        return this.mPWFiltered.size();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Category";
            }
            case 1: {
                return "Reference";
            }
            case 2: {
                return "User Name";
            }
            case 3: {
                return "Password";
            }
            case 4: {
                return "Remark";
            }
            case 5: {
                return "Hint";
            }
            case 6: {
                return "Url";
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return URL.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Password pw = this.mPWFiltered.get(row);
        switch (col) {
            case 0: {
                Integer catId = pw.getmCategory();
                String catStr = this.mCategoryMap.get(catId).concat("(").concat(catId.toString()).concat(") ");
                return catStr;
            }
            case 1: {
                return pw.getmReference();
            }
            case 2: {
                return pw.getmUserName();
            }
            case 3: {
                return pw.getmPassword();
            }
            case 4: {
                return pw.getmRemark();
            }
            case 5: {
                return pw.getmHint();
            }
            case 6: {
                return pw.getmURL();
            }
        }
        return null;
    }

    public Object getValueAtOrig(int row, int col) {
        Password pw = this.mPW.get(row);
        switch (col) {
            case 0: {
                return pw.getmCategory();
            }
            case 1: {
                return pw.getmReference();
            }
            case 2: {
                return pw.getmUserName();
            }
            case 3: {
                return pw.getmPassword();
            }
            case 4: {
                return pw.getmRemark();
            }
            case 5: {
                return pw.getmHint();
            }
            case 6: {
                return pw.getmURL();
            }
        }
        return null;
    }
}

