/*
 * Decompiled with CFR 0.152.
 */
package de.qbert.doc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class MRU {
    private static String FILENAME = "mru.txt";
    private List<String> mruList;
    private int mruSize;

    public MRU(int size) {
        this.mruSize = size;
        this.mruList = new ArrayList<String>(size);
        this.loadStrings();
    }

    public void addString(String str) {
        int index = -1;
        ListIterator<String> it = this.mruList.listIterator();
        while (it.hasNext() && index == -1) {
            if (!it.next().equalsIgnoreCase(str)) continue;
            index = it.previousIndex();
        }
        if (index != -1) {
            this.mruList.remove(index);
        }
        if (this.mruList.size() >= this.mruSize) {
            this.mruList.remove(0);
        }
        this.mruList.add(str);
        this.saveStrings();
    }

    public List<String> getStrings() {
        return this.mruList;
    }

    public boolean loadStrings() {
        boolean ret = true;
        this.mruList.clear();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader fis = new BufferedReader(new FileReader(FILENAME));){
                String str;
                while ((str = fis.readLine()) != null) {
                    this.addString(str);
                }
                fis.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
            ret = false;
        }
        return ret;
    }

    public void saveStrings() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedWriter fos = new BufferedWriter(new FileWriter(FILENAME));){
                ListIterator<String> it = this.mruList.listIterator(0);
                while (it.hasNext()) {
                    String str = it.next();
                    fos.write(str);
                    fos.write("\r\n");
                }
                fos.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
        }
    }
}

