/*
 * Decompiled with CFR 0.152.
 */
package de.qbert.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class URLRenderer
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private int row = -1;
    private int col = -1;
    private boolean isRollover = false;

    URLRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str;
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        String string = str = value != null ? value.toString() : "";
        if (!table.isEditing() && this.row == row && this.col == column && this.isRollover) {
            this.setText("<html><u><font color='blue'>" + str);
        } else if (hasFocus) {
            this.setText("<html><font color='blue'>" + str);
        } else {
            this.setText(str);
        }
        return this;
    }

    private boolean isURLColumn(JTable table, int column) {
        return column >= 0 && table.getColumnClass(column).equals(URL.class);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Rectangle repaintRect;
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int prev_row = this.row;
        int prev_col = this.col;
        boolean prev_ro = this.isRollover;
        this.row = table.rowAtPoint(pt);
        this.col = table.columnAtPoint(pt);
        this.isRollover = this.isURLColumn(table, this.col);
        if (this.row == prev_row && this.col == prev_col && this.isRollover == prev_ro || !this.isRollover && !prev_ro) {
            return;
        }
        if (this.isRollover) {
            Rectangle r = table.getCellRect(this.row, this.col, false);
            repaintRect = prev_ro ? r.union(table.getCellRect(prev_row, prev_col, false)) : r;
        } else {
            repaintRect = table.getCellRect(prev_row, prev_col, false);
        }
        table.repaint(repaintRect);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (this.isURLColumn(table, this.col)) {
            table.repaint(table.getCellRect(this.row, this.col, false));
            this.row = -1;
            this.col = -1;
            this.isRollover = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point pt;
        int ccol;
        JTable table = (JTable)e.getSource();
        if (this.isURLColumn(table, ccol = table.columnAtPoint(pt = e.getPoint()))) {
            int crow = table.rowAtPoint(pt);
            String strUrl = (String)table.getValueAt(crow, ccol);
            if (!strUrl.isEmpty() && strUrl.startsWith("www.")) {
                strUrl = "http://".concat(strUrl);
            }
            URL url = null;
            try {
                url = new URL(strUrl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(table.getParent(), "URL not recognized.", "Error", 0);
                return;
            }
            System.out.println(url);
            try {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(url.toURI());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(table.getParent(), "Error starting browser", "Error", 0);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

